(* 	Scripting with Merlin 2

	You may incorporate this ProjectWizards sample code into your program(s) without
	restriction.  This ProjectWizards sample code has been provided "AS IS" and the
	responsibility for its operation is yours.  You are not permitted to
	redistribute this ProjectWizards sample code as "ProjectWizards sample code" after having
	made changes.  If you're going to redistribute the code, we require
	that you make it clear that the code was descended from ProjectWizards sample
	code, but that you've made changes.

	Copyright 2010 ProjectWizards, Melle, Germany. All rights reserved.
*)

(*
	This script goes thought your current Merlin activities selection and transfers it into iCal
	
	Start date will be planned start date 
	End Date will be planned end date
	
	
	Author: 		Vicky Stamatopoulou	
	
*)
--
---------------------------


tell application "Merlin"
	activate
	set myselection to selected object of main window of document 1 
		as list
	
	if (count of myselection) is 0 then
		display dialog "Please select the activities you would 
		like to handle." buttons {"OK"}
	else
		
		set doc to the first document
		set proj to root project of doc
		set TheMerlinProj to title of proj
		
		tell application "iCal"
			set calname to "AS -" & TheMerlinProj
			try
				get calendar calname
				activate
				display dialog "Found a calendar in ical created by a previous run of this script. A new calendar will be created to avoid creation of dublicate events." buttons {"OK"}
			end try
			
			set mycal to make new calendar with properties {name:calname}
			
		end tell
		set allActivities to myselection
		
		repeat with act in allActivities
			set TheTitle to title of act as text
			if class of act is activity then
				try
					set TheDueDate to (planned start date of act) as date
				on error
					set TheDueDate to (expected start date of act) as date
				end try
				try
					
					set TheDueEnd to (planned end date of act) as date
				on error
					set TheDueEnd to (expected end date of act) as date
				end try
				
				
				tell application "iCal" to set myevent to make new event at end of mycal with properties {summary:TheTitle, start date:TheDueDate, end date:TheDueEnd, description:"AS"}
				
				
				
				
			end if
		end repeat
		tell application "iCal" to activate
	end if
end tell
